<?php

namespace App\Providers;

use App\Models\Can;
use App\Models\Profile;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Gate::define('can_add_product', function () {
            $can = Can::where('user_id',Auth::id())->first();
            if(isset($can->stock)){
                if ((Auth::user()->profile->status === 'verified') && ($can->stock > 0)){
                    return  true;
                }
            }
            return false;
        });


        VerifyEmail::toMailUsing(function (object $notifiable, string $url) {
            // dd('hi');
        return (new MailMessage)
            ->subject('Verify Email Address')
            ->view('emails.email-verify', ['url' => $url]);

            // ->line('Click the button below to verify your email address.')
            // ->action('Verify Email Address', $url);
        });
        // Paginator::useBootstrapFive();
        // Paginator::useBootstrapFour();
    }
}
