<?php

namespace App;

use App\Mail\OrderConfirmationMail;
use App\Models\Order;
use Illuminate\Support\Facades\Mail;

trait OrderConfirmationTrait
{
    // This method sends the order confirmation email
    public function sendOrderConfirmationMail($order_data)
    {
        // Send email to the user's email address
        Mail::to($order_data->email)->send(new OrderConfirmationMail($order_data));
    }
}
