<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Str;
use Laravel\Cashier\Billable;

class User extends Authenticatable //implements MustVerifyEmail
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, Billable;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $guarded = [];
    // protected $fillable = [
    //     'name',
    //     'email',
    //     'password',
    // ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
    public static function boot()
    {
        parent::boot();

        // Generate a verification token when a new user is created
        static::creating(function ($user) {
            $user->verification_token = Str::uuid();
        });
    }

    public function hasVerifiedEmail()
{
    return $this->email_verified_at !== null;
}

    public function ads(){
        return $this->hasMany(Ad::class);
    }

    public function profile(){
        return $this->hasOne(Profile::class);
    }

    public function cans(){
        return $this->hasOne(Can::class);
    }

    public function verification(){
        return $this->hasOne(verification::class);
    }

    public function message(){
        return $this->hasMany(Message::class);
    }

    public function orders(){
        return $this->hasMany(Cart::class);
    }
    

    public function can_request(){
        return $this->hasMany(CanRequest::class);
    }

    public function sellerad(){
        return $this->hasMany(SellerAd::class);
    }

    public function account(){
        return $this->hasMany(Accounts::class);
    }

    public function payment_request(){
        return $this->hasMany(PaymentRequest::class);
    }

    public function isPremium()
    {
        return $this->subscribed('default') && $this->subscription('default')->stripe_plan === 'price_1QckeODOV3QK0LcGWEj7pRxb';
    }
    
    public function isPSeller()
{
    return $this->is_premium ?? false; // Assume 'is_premium' column exists in users table
}

    public function isPremiumSeller()
    {
        return $this->is_premium && $this->membership_expires_at > now();
    }

    public function reports() {
        return $this->hasMany(Report::class, 'seller_id');
    }
    
    public function activityLogs(){
        return $this->hasMany(ActivityLog::class);
    }

    public function adminMessages()
{
    return $this->hasMany(AdminMessage::class, 'seller_id');
}
public function isPeller() {
    return optional($this->profile)->membership_id == 2;
}
}
