<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SellerActivityLog extends Model
{
    use HasFactory;
    protected $fillable = [
        'seller_id',
        'ip_address',
        'location',
        'browser_details',
        'activity_time',
    ];

    public $timestamps = false; // Hum already custom timestamp field use kar rahe hain

    // Relationship with User (Seller)
    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id');
    }

    public function activityLogs()
    {
        return $this->hasMany(ActivityLog::class, 'user_id', 'seller_id');
    }
    
}
