<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MediaPurchase extends Model
{
    use HasFactory;

    protected $fillable = [
        'seller_id',
        'name',
        'buyer_email',
        'media_id',
        'status',
    ];

    // Relationship with User (Seller)
    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id');
    }

    // Relationship with Media File
    public function media()
    {
        return $this->belongsTo(MediaFile::class, 'media_id');
    }
}
