<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MediaFile extends Model
{
    use HasFactory;


    protected $fillable = [
        'seller_id',
        'name',
        'file_path',
        'external_link',
        'price',
        'type',
    ];

    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id');
    }
}
