<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdminMessage extends Model
{
    use HasFactory;

    protected $fillable = ['seller_id', 'message', 'is_read'];

    // Relationship with User (Seller)
    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id');
    }
}

