<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ad extends Model
{
    /** @use HasFactory<\Database\Factories\AdFactory> */
    use HasFactory;

    protected $fillable = ['user_id', 'type','ad_status','title', 'image', 'gallery', 'description' , 'price', 'worn_days', 'drugs_free', 'free_of_diseases', 'approved', 'paused'];

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function profile(){
        return $this->hasOneThrough(Profile::class, User::class);
    }
    public function orders(){
        return $this->hasMany(Order::class);
    }
    public function cart(){
        return $this->hasMany(Cart::class);
    }

    public function report(){
        return $this->hasMany(Report::class);
    }

    public function additional_refinement(){
        return $this->hasMany(AdditionalRefinement::class);
    }

    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id');
    }

    public function setting()
    {
        return $this->belongsTo(Setting::class, 'setting_id');
    }
    public function sellerpayment()
    {
        return $this->hasOne(SellerPayment::class);
    }

    public static function getMaxPriceAd(){
        return self::max('price');
    }

    protected $casts = [
        'gallery' => 'array',
    ];
}
