<?php
namespace App\Mail;

use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PurchaseNotification extends Mailable
{
    use SerializesModels;

    public $user;
    public $order;

    /**
     * Create a new message instance.
     *
     * @param  $user
     * @param  $order
     * @return void
     */
    public function __construct($user, $order)
    {
        $this->user = $user;
        $this->order = $order;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Your Purchase Has Been Confirmed')
                    ->view('emails.purchase_notification');
    }
}
