<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

// app/Mail/OrderSentEmail.php

use Illuminate\Support\Facades\Log;

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderSentEmail extends Mailable
{
    public $order;
    public $pdfPath;
    public $videoPath;

    public function __construct($order, $pdf = null, $media = null)
    {
        $this->order = $order;
        $this->pdfPath = $pdf;
        $this->videoPath = $media;
    }

    public function build()
    {
        return $this->view('emails.order_sent')
                    ->with([
                        'order' => $this->order,
                        'pdfPath' => $this->pdfPath,
                        'videoPath' => $this->videoPath,
                    ]);
    }
}