<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderInProgressEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $order;

    // Constructor to pass the order data
    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    public function build()
    {
        // You can customize the email subject, view, etc.
        return $this->subject('Your Order is In Progress')
                    ->view('emails.order_in_progress');
    }
}

