<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AccountDeleted extends Mailable
{
    use Queueable, SerializesModels;

    public $sellerName;
    public $recipientType; // "seller" ya "admin"

    public function __construct($sellerName, $recipientType)
    {
        $this->sellerName = $sellerName;
        $this->recipientType = $recipientType;
    }

    public function build()
    {
        return $this->subject($this->recipientType == 'seller' ? 'Account Deletion Confirmation' : 'Seller Account Deleted')
                    ->view('emails.account_deleted')
                    ->with([
                        'sellerName' => $this->sellerName,
                        'recipientType' => $this->recipientType,
                    ]);
    }
}