<?php

namespace App\Jobs;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
class DeleteUnverifiedUser implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $userId;

    /**
     * Create a new job instance.
     */
    public function __construct($userId)
    {
        $this->userId = $userId;
    }
    /**
     * Execute the job.
     */
    public function handle()
    {
        $user = User::find($this->userId);
        if ($user && Carbon::now()->gt($user->otp_expires_at)) {
            Log::info('Deleting unverified user', ['user_id' => $this->userId]);
            $user->delete();
        } else {
            Log::info('User is verified or not expired', ['user_id' => $this->userId]);
        }
    }
}
