<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Profile;

class EnsureProfileOwnership
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Retrieve the profile being accessed
        $profile = Profile::find($request->route('profile'));

        // Check if the profile exists and if it belongs to the authenticated user
        if (!$profile || $profile->user_id !== auth()->id()) {
            return response('Unauthorized access to this profile.', 403);
        }

        // Proceed to the next middleware or controller
        return $next($request);
    }
}
