<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Message;
use App\Models\Profile;
use App\Models\Sellerad;
use App\Models\User;
use App\Models\MediaFile;
use App\Models\Report;
use App\Models\verification;
use App\Models\AdminMessage;
use App\Models\Ad;
use App\Models\Membership;
use Stripe\Stripe;
use Stripe\PaymentIntent;
use App\Models\MediaPurchase;
use App\Models\SellerActivityLog;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use App\Mail\AccountDeleted;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Hash;



class SellerController extends Controller
{    
     public function sellermembership(){
        // dd('Membership');
        $memberships = Membership::all();
        return view('seller.membership', compact('memberships'));
    }

    public function deleteAccount(Request $request)
{
    $request->validate([
        'password' => 'required',

    ]);

    $user = Auth::user();
    if (!$user) {
        return response()->json(['error' => 'Unauthorized'], 401);
    }

    if (!Hash::check($request->password, auth()->user()->password)) {
        return response()->json([
            'message' => 'Invalid password.',
            'redirect_url' => route('ad.return-back-failed')
        ], 403);
    }


    $email = $user->email;
    $sellerName = $user->name;
    $adminValue = User::where('role', 'admin')->first();
    $adminEmail = $adminValue ? $adminValue->email : null;

    Log::info("Seller $sellerName ($email) deleted their account.");

    Mail::to($email)->send(new AccountDeleted($sellerName, 'seller'));

    Mail::to($adminEmail)->send(new AccountDeleted($sellerName, 'admin'));

    $user->delete();

    return response()->json(['message' => 'Your account has been deleted successfully.']);
}


    public function contactAdmin()
{
    return view('seller.contact_admin');
}

public function sendAdminMessage(Request $request)
{
    $request->validate([
        'message' => 'required|string|min:10',
    ]);

    AdminMessage::create([
        'seller_id' => auth()->id(),
        'message' => $request->message,
        'is_read' => false,
    ]);

    return redirect('/profile')->with('success', 'Your message has been sent to the administrator.');
}

public function showmediafile(){
    $user = auth()->user();
    $mediafiles = MediaFile::where('seller_id', $user->id)->orderBy('created_at', 'desc')->get();
    return view('seller.showmediafiles', compact('mediafiles'));
}


    public function mediafile(){
        return view('seller.mediafile');
    }

    public function uploadMedia(Request $request)
{
    $user = auth()->user();
    $membership = $user->profile->membership ?? (object) ['name' => 'Standard', 'type' => 'standard'];

    $premiumLimit = 1;
    $standardLimit = 3;

    $uploadsToday = MediaFile::where('seller_id', $user->id)
        ->whereDate('created_at', today())
        ->count();

    if ($membership->name === 'Premium' && $uploadsToday >= $premiumLimit) {
        return redirect()->back()->with('error', 'As a Premium seller, you can only upload  media file per month.');
    }

    if ($membership->name === 'Standard' && $uploadsToday >= $standardLimit) {
        return redirect()->back()->with('error', 'As a Standard seller, you can only upload 3 media files per month.');
    }

    $validated = $request->validate([
        'name' => 'required',
        'media_file' => 'nullable|file|mimes:webp,mp4,avi,mov,wmv,mkv|max:51200',
        'external_link' => 'nullable|url',
        'price' => 'required',
    ]);

    $media = new MediaFile();
    $media->seller_id = $user->id;
    $media->name = $request->name;
    $media->price = $request->price;

    if ($request->hasFile('media_file')) {
        $file = $request->file('media_file');
        $filePath = $file->store('media/snippets', 'public');
        $media->file_path = $filePath;
        $media->type = $this->getFileType($file);
    }

    if (!empty($request->external_link)) {
        $this->validateExternalLink($request->external_link);
        $media->external_link = $request->external_link;
        $media->type = 'external_link';
    }

    $media->save();
    return redirect('/profile')->with('success', 'Media file uploaded successfully!');
}

public function showmediafileEdit($id){
    $mediafile = MediaFile::find($id);
    return view('seller.editmediafile', compact('mediafile'));
}

public function showmediafileUpdate(Request $request, $id)
{
    $media = MediaFile::findOrFail($id);
    $user = auth()->user();

    $validated = $request->validate([
        'name' => 'required',
        'media_file' => 'nullable|file|mimes:webp,mp4,avi,mov,wmv,mkv|max:51200',
        'external_link' => 'nullable|url',
        'price' => 'required',
    ]);

    $media->name = $request->name;
    $media->price = $request->price;

    // **File Upload Handling**
    if ($request->hasFile('media_file')) {
        $file = $request->file('media_file');

        // **Check file mil rahi hai ya nahi**
        if (!$file->isValid()) {
            return redirect()->back()->with('error', 'Invalid file upload.');
        }

        // **Pehle wali file delete karein**
        if (!empty($media->file_path)) {
            Storage::disk('public')->delete($media->file_path);
        }

        // **Nayi file store karein**
        $filePath = $file->store('media/snippets', 'public');
        
        if (!$filePath) {
            return redirect()->back()->with('error', 'File upload failed.');
        }

        // Debugging: Check file path
        // dd($filePath);

        $media->file_path = $filePath;
        $media->type = $this->getFileType($file);
        $media->external_link = null;
    }

    // **External Link Handling**
    if (!empty($request->external_link)) {
        $this->validateExternalLink($request->external_link);
        $media->external_link = $request->external_link;
        $media->type = 'external_link';

        // Agar external link update ho rahi hai, purani file delete karein
        if (!empty($media->file_path)) {
            Storage::disk('public')->delete($media->file_path);
            $media->file_path = null;
        }
    }

    $media->save();

    return redirect('/profile')->with('success', 'Media file updated successfully!');
}

public function showmediafileDelete($id){
    $mediafile = MediaFile::find($id);
    $mediafile->delete();
    return redirect('/profile')->with('success', 'Media file Deleted successfully!');
}


    protected function validateExternalLink($link)
{
    $allowedProviders = ['drive.google.com', 'docs.google.com', 'dropbox.com', 'onedrive.live.com'];
    $url = parse_url($link);
    if (!isset($url['host']) || !in_array($url['host'], $allowedProviders)) {
        abort(403, 'Only links from Google Drive, Dropbox, and OneDrive are allowed!');
    }
}


public function sendMediaLink(Request $request, $id)
{
    $purchase = \App\Models\MediaPurchase::findOrFail($id);

    // Buyer ke saare purchases fetch karein
    $media_purchases = \App\Models\MediaPurchase::where('buyer_email', $purchase->buyer_email)->get();

    // Media ka link set karein
    $mediaLink = $purchase->media->type == 'external_link' 
        ? $purchase->media->external_link 
        : url('storage/' . $purchase->media->file_path);

    // Mail bhejne ka function call karein
    Mail::send('emails.purchase_notification', [
        'purchase' => $purchase,
        'mediaLink' => $mediaLink,
        'media_purchases' => $media_purchases
    ], function ($message) use ($purchase) {
        $message->to($purchase->buyer_email)
                ->subject('Your Media Purchase Link');
    });
    return redirect('/profile')->with('success', 'Mail Sent successfully!');
}

    protected function getFileType($file)
    {
        $mime = $file->getMimeType();
        if (in_array($mime, ['image/jpeg', 'image/png', 'image/gif', 'image/webp'])) {
            return 'image';
        } elseif (in_array($mime, ['video/mp4', 'video/avi', 'video/mov', 'video/wmv', 'video/mkv'])) {
            return 'video';
        }
        return 'unknown';
    }

    public function showMedia(){
        $media_purchases = MediaPurchase::with('seller', 'media')
        ->orderBy('created_at','desc')->get();
        return view('seller.showmedia', compact('media_purchases'));
    }


    public function lovecanwomen(){
        return view('seller.lovecanwomen');
    }

    public function submitLovecansAd(Request $request)
{
    $user = auth()->user();
    if ($user->gender !== 'female') {
        return redirect()->back()->with('error', 'Only female sellers can submit Lovecans offers.');
    }

    // Validate request data
    $validated = $request->validate([
        'title' => 'required|string|max:255',
        'type' => 'required',
        'price' => 'required|integer|min:1',
        'quantity' => 'required|integer|min:1',
        'worn_days' => 'required|integer|min:2',
        'description' => 'required|string|max:255',
        'image' => 'required|file|mimes:jpg,jpeg,png',
        'free_of_diseases' => 'required',
        'drugs_free' => 'required',
    ]);

    $lastLovecansAd = Ad::where('user_id', $user->id)
        ->where('is_lovecans', true)
        ->where('created_at', '>=', now()->subHours(48))
        ->exists();

    if ($lastLovecansAd) {
        return redirect()->back()->with('error', 'You can only submit one Lovecans offer every 48 hours.');
    }

    $adImage = time().'.'.$request->image->getClientOriginalExtension();
    $request->image->move(public_path('storage/ads'), $adImage);
    $validated['image'] = $adImage;

    $ad = new Ad($validated);
    $ad->user_id = $user->id;
    $ad->is_lovecans = true;
    $ad->admin_approved = false;

    if ($ad->save()) {
        $can = $user->cans()->first();
        if ($can) {
            $can->stock -= 1;
            $can->save();
        }
        return redirect('/profile')->with('success', 'Lovecans product submitted successfully! It will be listed after admin approval.');
    }

    return redirect()->back()->with('error', 'Failed to submit Lovecans offer. Please try again.');
}


    public function calculateAdFee(Request $request)
{
    $fee = ($request->is_lovecans) ? 0 : 5;
    return response()->json(['fee' => $fee]);
}



    public function delete_seller($id){
        User::destroy($id);
        return redirect()->back();
    }

    public function update_seller_status(Request $request, $id){
        if($request->status == 'verified' || $request->status == 'blocked'){
            $user_id = Profile::where('id', $id)->get();
            foreach($user_id as $user){}
            if($user->user_id){
                $files = verification::where('user_id', $user->user_id)->get();
                foreach($files as $file){
                    if(file_exists('storage/'.$file->file_path)){
                        unlink(public_path('storage/'.$file->file_path));
                    }
                }
                $files = verification::where('user_id', $user->user_id)->delete();
            }
           
        }
        Profile::where('id', $id)
        ->update(['status' => $request->status]);
        return redirect()->back();
    }
    
    public function seller_messages($id){
        $messages = Message::with('user')->where('user_id', $id)->orderBy('id', 'desc')->paginate(10);
        return view('admin.send-messages', ['messages' => $messages, 'user_id' => $id]);
    }
    
      public function testing(){
        $messages = Message::orderBy('id', 'desc')->paginate(5);
        return view('admin.test', compact('messages'));
    }

    public function seller_send_message(Request $request, $id){
        $request->validate([
            'subject' => 'required',
            'message' => 'required'
        ]);
        Message::create([
            'user_id' => $id,
            'message' => $request->message,
            'subject' => $request->subject
        ]);
        return redirect()->back()->with('success', 'Message sent successfully');
    }

  public function messages(Request $request){
          
        $query = User::with(['profile', 'message' => function ($q) {
            $q->latest('created_at')->take(1);
        }])
            ->whereHas('message', function ($q) use ($request) {
                if ($request->has('search') && $request->search != '') {
                    $q->where('subject', 'like', '%' . $request->search . '%')
                        ->orWhere('message', 'like', '%' . $request->search . '%');
                }
            })
            ->when($request->has('search') && $request->search != '', function ($query) use ($request) {
                $query->where('name', 'like', '%' . $request->search . '%');
            });
        $messages = $query
            ->addSelect(['last_message_at' => Message::select('created_at')
                ->whereColumn('user_id', 'users.id')
                ->latest('created_at')
                ->limit(1)
            ])
            ->orderByDesc('last_message_at')
            ->paginate(50);

        return view('admin.messages',compact('messages'));

    }

    function sell_to_lovecans(Request $request){
        return view('seller.sell-to-lovecans');
    }

    public function create_ad(Request $request){        
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'type' => 'required',
            'price' => 'required|integer|min:1',
            'quantity' => 'required|integer|min:1',
            'worn_days' => 'required|integer|min:1|max:7',
            'description'=> 'required|string|max:255',
            'image' => 'required|file|mimes:jpg,jpeg,png',
            'free_of_diseases' => 'required',
            'drugs_free'=> 'required',
        ]);

        $adImage = time().'.'.$request->image->getClientOriginalExtension();
        $request->image->move(public_path('storage/ads'), $adImage);
        $validated['image'] = $adImage;
        $ad = new Sellerad($validated);
        $ad->user_id = auth()->id();
        if( $ad->save()){
            $can = auth()->user()->cans()->first();
            $can->stock -= 1;
            $can->save();
           return redirect('/profile')->with('success','Offer created successfully.');
        }

        return redirect()->back()->with('error', 'Failed to create offer. Please Try again.');
    }

    public function sell_offers(){
        $offers = Sellerad::where('user_id', auth()->id())->get();
        return view('seller.sell-offers', compact('offers'));
    }

    public function show_profile($id){
        $sellers = DB::table('users')->join('profiles','users.id','profiles.user_id')
        ->select('users.*','profiles.id as profile_id','profiles.*')
        ->where('profiles.id',$id)
        ->get();
        return view('admin.show_seller', compact('sellers'));
    }

    public function show_report($id){
        $reports = Report::with('user', 'ad')->find( $id );
        return view('admin.show_report', compact('reports'));
    }

    public function showselleractivitylog($id)
    {
        $sellerrecprds = SellerActivityLog::with(['seller', 'seller.activityLogs'])->findOrFail($id);
        return view('admin.showselleractivitylog', compact('sellerrecprds'));
    }
    
    

public function selleractivitylogdelete($id){
    $sellerrecprds = SellerActivityLog::find($id);
    $sellerrecprds->delete();
    return back();
}   
    
}