<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Ad;
use App\Models\Category;
use App\Models\Report;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    public function index(Request $request)
{
    $query = Ad::query();

    // Search filter if provided
    if ($request->has('search') && $request->search != '') {
        $query->where('title', 'like', '%' . $request->search . '%');
    }

    // Eager load the payment status
    $products = $query->with('sellerpayment') // This will load the payment relationship
                      ->orderBy('id', 'desc')
                      ->paginate(20)
                      ->withQueryString();

    return view('admin.products', compact('products'));
}

public function filter(Request $request)
{
    $max = Ad::getMaxPriceAd();
    $categories = Category::all();
    $query = Ad::query();

    $query->where('status', 'Approved');

    if ($request->has('category') && $request->category != 'select category') {
        $type = Category::findOrFail($request->category);
        $query->where('type', $type->category);
    }

    if($request->has('worn_days') && $request->worn_days != 'select worn days') {
        $query->where('worn_days', $request->worn_days);
    }

    if($request->has('minPrice') && $request->minPrice > 0) {
        \Log::info('running');
        $query->where('price', '>=', $request->minPrice);
    }

    if($request->has('maxPrice') && $request->maxPrice < $max) {
        \Log::info('max running');
        $query->where('price', '<=', $request->maxPrice);
    }

    if($request->has('gender') && $request->gender != 'select gender'){
        $query->whereHas('user.profile', function ($q) use ($request) {
            $q->where('gender', $request->gender);
        });
    }

    if($request->has('clothing_size') && $request->clothing_size != 'select clothing size'){
        $query->whereHas('user.profile', function ($q) use ($request) {
            $q->where('clothing_size', $request->clothing_size);
        });
    }

    if ($request->has('refinement_title') && is_array($request->refinement_title)) {
        $refinements = $request->refinement_title;

        $query->whereHas('additional_refinement', function ($q) use ($refinements) {
            $q->whereIn('refinement_title', $refinements);
        });
    }


    $ads = $query->get();
    return view('user.productss', compact('ads', 'categories','max'));
}

    
    public function update_product_status(Request $request, $id)
{
    Ad::where('id', $request->id)
        ->update(['status' => $request->status]);

    $reportCount = Report::where('ad_id', $id)->count();
    if ($reportCount >= 2) {
        $ad = Ad::find($id);
        $seller = $ad->user;

        if ($seller->status !== 'blocked') {
            $seller->update(['status' => 'blocked']);
        }
    }
    return redirect()->back();
}



}
