<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Membership;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Log;

class MembershipController extends Controller
{


    public function index(Request $request)
    {
        Log::info('Fetching all Membership', ['search' => $request->search]);
        $query = Membership::orderBy('created_at', 'desc');
        if ($request->has('search') && !empty($request->search)) {
            $query->where('name', 'LIKE', '%' . $request->search . '%');
        }
        $plans = $query->paginate(20);
        return view('admin.plans.all-plans', compact('plans'));
    }

    public function create()
    {
        Log::info('Opening create plan form');
        return view('admin.plans.add-plan');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'ad_limit' => 'required',
            'price' => 'required|numeric',
            'image_limit' => 'required|integer',
            'duration_days' => 'required|integer',
        ]);

        $membership = Membership::create($request->all());
        Log::info('New membership created', ['plan_id' => $membership->id]);

        return redirect()->route('admin.membership')->with('success', 'membership created successfully.');
    }

        public function edit($id)
    {
        $membership = Membership::findOrFail($id);
        Log::info('Editing plan', ['membership_id' => $id]);

        return view('admin.plans.plan-edit', compact('membership'));
    }

     public function update(Request $request, $id)
    {
        $memberships = Membership::findOrFail($id);

        $request->validate([
            'name' => 'required',
            'ad_limit' => 'required',
            'price' => 'required|numeric',
            'image_limit' => 'required|integer',
            'duration_days' => 'required|integer',
        ]);

        $memberships->update([
            'name' => $request->name,
            'ad_limit' => $request->ad_limit,
            'price' => $request->price,
            'image_limit' => $request->image_limit,
            'duration_days' => $request->duration_days
        ]);

        Log::info('Membership updated', ['Membership_id' => $id]);

        return redirect()->route('admin.membership')->with('success', 'Membership Updated successfully.');
    }

    public function destroy($id)
    {
        $membership = Membership::find($id);
        if (!$membership) {
            Log::warning('Plan not found for deletion', ['membership_id' => $id]);
            return redirect()->route('admin.membership')->with('error', 'membership not found.');
        }

        $membership->delete();
        Log::info('membership deleted', ['membership_id' => $id]);

        return redirect()->route('admin.membership')->with('success', 'membership deleted successfully.');
    }

//     public function index()
//     {
//         $sellers = User::where('role', 'seller')->get(); // Get only sellers
//         return view('admin.memberships', compact('sellers'));
//     }

//     public function update(Request $request)
// {
//     $request->validate([
//         'user_id' => 'required|exists:users,id',
//         'membership_price' => 'nullable|numeric',
//         'membership_duration' => 'nullable|integer',
//     ]);

//     $seller = User::findOrFail($request->user_id);
//     $seller->is_premium = $request->has('is_premium');
//     $seller->membership_price = $request->membership_price;
//     $seller->membership_duration = $request->membership_duration;
    
//     // Ensure membership_duration is converted to an integer
//     $duration = (int) $request->membership_duration;

//     // If duration is set, calculate expiry date
//     $seller->membership_expires_at = $duration > 0 ? now()->addDays($duration) : null;

//     $seller->save();

//     return back()->with('success', 'Membership updated successfully!');
// }

}
