<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MediaFile;
use App\Models\MediaPurchase;
use Illuminate\Support\Facades\Log;
use Stripe\Stripe;
use Stripe\Checkout\Session;

class UserMediaController extends Controller
{
    public function mediapurchace($id){
        $mediaItem = MediaFile::find( $id );
        return view('seller.mediapurchase',compact('mediaItem'));
    }

    
    public function purchaseMedia(Request $request, $mediaId)
    {
        $media = MediaFile::findOrFail($mediaId);
    
        $purchase = new MediaPurchase();
        $purchase->seller_id = $media->seller_id;
        $purchase->media_id = $media->id;
        $purchase->name = $request->name;
        $purchase->buyer_email = $request->buyer_email;
        $purchase->save();

        Stripe::setApiKey(env('STRIPE_SECRET'));
    
        try {
            $session = Session::create([
                'payment_method_types' => ['card'],
                'customer_email' => $request->buyer_email,
                'line_items' => [[
                    'price_data' => [
                        'currency' => 'usd', 
                        'product_data' => [
                            'name' => $media->name,
                        ],
                        'unit_amount' => intval($media->price * 100),
                    ],
                    'quantity' => 1,
                ]],
                'mode' => 'payment',
                'success_url' => route('user.payment.success', ['purchaseId' => $purchase->id]),
                'cancel_url' => route('user.payment.cancel'),
            ]);
    
            Log::info('Stripe Checkout Session Created:', ['session' => $session]);
    
            return redirect()->away($session->url);
            
        } catch (\Exception $e) {
            Log::error('Stripe Checkout Error:', ['error' => $e->getMessage()]);
    
            return redirect()->back()->with('error', 'Payment processing failed. Please try again.');
        }
    }
    


public function paymentSuccess($purchaseId)
{
    $purchase = MediaPurchase::findOrFail($purchaseId);
    $purchase->status = 'paid';
    $purchase->save();

    return view('seller.payment-success', compact('purchase'));
}

public function paymentCancel()
{
    return view('seller.payment-cancel');
}


}
