<?php

namespace App\Http\Controllers;

use App\Models\Plan;
use Laravel\Cashier\Exceptions\IncompletePayment;
use Illuminate\Http\Request;

class SubscriptionController extends Controller
{
    public function subscribe(Request $request)
    {
        $plan = Plan::findOrFail($request->plan_id);

        try {
            $request->user()->newSubscription('default', $plan->stripe_price_id)->create($request->paymentMethod);

            return redirect()->route('dashboard')->with('success', 'You are now subscribed to ' . $plan->name);
        } catch (IncompletePayment $exception) {
            return redirect()->route('cashier.payment', [$exception->payment->id, 'redirect' => route('dashboard')]);
        }
    }

    public function cancelSubscription()
    {
        auth()->user()->subscription('default')->cancel();
        return redirect()->route('dashboard')->with('success', 'Subscription canceled.');
        $isPremium = auth()->user()->subscribed('default') && auth()->user()->subscription('default')->stripe_plan === 'price_premium_123';

    }
    public function isPremium()
    {
        return $this->subscribed('default') && $this->subscription('default')->stripe_plan === 'price_premium_123';
    }

}
