<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SubCategory;
use App\Models\Category;
use App\Models\Ad;

class SubCategoryController extends Controller
{
    // List all subcategories
    public function index()
    {
        $subCategories = SubCategory::with('category')->paginate(10);
        return view('admin.sub_categories.index', compact('subCategories'));
    }

    // Show create form
    public function create()
    {
        $categories = Category::all();
        return view('admin.sub_categories.create', compact('categories'));
    }

    // Store subcategory
    public function store(Request $request)
{
    $request->validate([
        'title' => 'required|string|max:255',
        'description' => 'required',
        'category_id' => 'required',
        'images' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048'
    ]);

    $data = $request->all();

    if ($request->hasFile('images')) {
        $imagePath = $request->file('images')->store('subcategories', 'public');
        $data['images'] = 'storage/' . $imagePath;
    }

    SubCategory::create($data);

    return redirect()->route('admin.sub-categories.index')->with('success', 'SubCategory created successfully');
}

    public function show($id)
{
    $category = Category::findOrFail($id);
    $ads = Ad::where('type', $category->category)->get();

    if (!$category) {
        return redirect()->back()->with('error', 'Category not found');
    }

    return view('subcategories', compact('category', 'ads'));
}

    // Show edit form
    public function edit($id)
    {
        $subCategory = SubCategory::find($id);
        $categories = Category::all();

        if (!$subCategory) {
            return redirect()->route('admin.sub-categories.index')->with('error', 'SubCategory not found');
        }

        return view('admin.sub_categories.edit', compact('subCategory', 'categories'));
    }

    // Update subcategory
        public function update(Request $request, $id)
{
    $subCategory = SubCategory::find($id);
    if (!$subCategory) {
        return redirect()->route('admin.sub-categories.index')->with('error', 'SubCategory not found');
    }

    $request->validate([
        'title' => 'required|string|max:255',
        'description' => 'required',
        'category_id' => 'required',
        'images' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048'
    ]);

    $data = $request->except(['images']);


    if ($request->hasFile('images')) {
        if (!$request->file('images')->isValid()) {
            return back()->with('error', 'Image upload failed.');
        }

        // Old Image ko delete karna agar exist karti hai
        if ($subCategory->images && file_exists(public_path($subCategory->images))) {
            unlink(public_path($subCategory->images));
        }

        // New Image Upload
        $imagePath = time() . '.' . $request->file('images')->getClientOriginalExtension();
        $request->file('images')->move(public_path('storage/subcategories'), $imagePath);
        $data['images'] = 'storage/subcategories/' . $imagePath;
    }

    $subCategory->update($data);

    return redirect()->route('admin.sub-categories.index')->with('success', 'SubCategory updated successfully');
}

    // Delete subcategory
    public function delete($id)
    {
        $subCategory = SubCategory::find($id);
        if (!$subCategory) {
            return redirect()->route('admin.sub-categories.index')->with('error', 'SubCategory not found');
        }

        $subCategory->delete();
        return redirect()->route('admin.sub-categories.index')->with('success', 'SubCategory deleted successfully');
    }
}
