<?php
      
namespace App\Http\Controllers;

use App\Models\CanRequest;
use Illuminate\Http\Request;
use Stripe\Stripe;
use Stripe\Charge;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;

class StripePaymentController extends Controller
{
    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function stripe(): View
    {
        return view('payment');
    }

    public function cans_payment(Request $request){

        try {
            // Set Stripe secret key from environment
            Stripe::setApiKey(env('STRIPE_SECRET'));

            // Get payment details from the request
            $amount = $request->price*100;
            $currency = 'USD'; // Change this to your desired currency
           
            // Charge the customer
            $charge = Charge::create([
                'amount' => $amount,
                'currency' => $currency,
                'source' => $request->stripeToken,
                'description' => 'Can Purchase',
            ]);
            $charge->id;
            // Check if the charge was successful
            if ($charge->status === 'succeeded') {

                // $user = auth()->user(); // Assuming the seller is authenticated
                // // Add cans to seller's stock
                // $can = $user->cans()->firstOrCreate();
                // $can->stock += $request->quantity;
                // $can->save();
                CanRequest::create([
                    'user_id' => auth()->user()->id,
                    'cans' => $request->quantity,
                    'amount' => $request->price,
                    'currency' => $currency,
                    'payment_id' => $charge->id,
                    'payment_status' => 'paid',
                    'source' => 'stripe',
                ]);

                return redirect('/store')->with('success', 'Cans purchased successfully!');
            }

            return redirect('/store')->with('error', 'Couldn`t make payment !');
        } catch (\Exception $e) {
            return redirect('/store')->with('error', $e->getMessage());
        }
    }
      
    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function stripePost(Request $request): RedirectResponse
    {
        Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
      
        Stripe\Charge::create ([
                "amount" => 10 * 100,
                "currency" => "usd",
                "source" => $request->stripeToken,
                "description" => "Test payment from itsolutionstuff.com." 
        ]);
        return back()
                ->with('success', 'Payment successful!');
    }
}
