<?php

namespace App\Http\Controllers;

use App\Models\SectionRight;
use Illuminate\Http\Request;

class SectionRightController extends Controller
{
    public function index(){
        $sectionsRight = SectionRight::orderBy('created_at', 'desc')->paginate(10);
        return view('admin.sectionright.index', compact('sectionsRight'));
    }

    public function create(){
        return view('admin.sectionright.create');
    }

    public function store(Request $request){
        $request->validate([
            'images' => 'required|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048'
        ]);

        if ($request->hasFile('images')) {
            $path = $request->file('images')->store('sectionright', 'public');
        }

        SectionRight::create([
            'images' => $path
        ]);

        return redirect()->route('sectionright.index')->with('success', 'Image uploaded successfully.');
    }

    public function edit($id){
        $sectionright = SectionRight::findOrFail($id);
        return view('admin.sectionright.edit', compact('sectionright'));

    }

    public function update(Request $request, $id){
        $sectionright = SectionRight::findOrFail($id);
        if (!$sectionright) {
            return redirect()->route('sectionright.index')->with('error', 'Image not found.');
        }
        $request->validate([
            'images' => 'required|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048'
        ]);

        if ($request->hasFile('images')) {
            if ($sectionright->images && file_exists(storage_path('app/public/' . $sectionright->images))) {
                unlink(storage_path('app/public/' . $sectionright->images));
            }
            $path = $request->file('images')->store('sectionright', 'public');
            $sectionright->images = $path;
        }
        $sectionright->save();
        return redirect()->route('sectionright.index')->with('success', 'Image Updated successfully.');
    }

    public function destroy($id){
        $sectionright = SectionRight::findOrFail($id);
        $sectionright->delete();
        return redirect()->route('sectionright.index')->with('success', 'Record Delete successfully.');
    }

}
