<?php

namespace App\Http\Controllers;

// use App\Models\Payment;

use App\Models\CanRequest;
use App\Models\Order;
use App\Models\OrderDetail;
use Illuminate\Http\Request;
use Omnipay\Omnipay;
use App\OrderConfirmationTrait;

class PaypalController extends Controller
{
    private $gateway;
    use OrderConfirmationTrait;

    public function __construct() {
        $this->gateway = Omnipay::create('PayPal_Rest');
        $this->gateway->setClientId(env('PAYPAL_CLIENT_ID'));
        $this->gateway->setSecret(env('PAYPAL_CLIENT_SECRET'));
        $this->gateway->setTestMode(true);
    }

    public function cans_payment(Request $request)
    {
        $price = $request->quantity*20;
        try {

            $response = $this->gateway->purchase(array(
                'amount' => $price,
                'currency' => env('PAYPAL_CURRENCY'),
                'returnUrl' => url('/success-payment/'.$request->quantity),
                'cancelUrl' => url('/error-payment')
            ))->send();

            if ($response->isRedirect()) {
                $response->redirect();
            }
            else{
                // return $response->getMessage();
                return redirect('/store')->with('error', $response->getMessage());
            }

        } catch (\Throwable $th) {
            // return $th->getMessage();
            return redirect('/store')->with('error', $th->getMessage());
        }
    }

    public function success(Request $request, $quantity)
    {
        if ($request->input('paymentId') && $request->input('PayerID')) {
            $transaction = $this->gateway->completePurchase(array(
                'payer_id' => $request->input('PayerID'),
                'transactionReference' => $request->input('paymentId')
            ));

            $response = $transaction->send();

            if ($response->isSuccessful()) {

                $arr = $response->getData();

                $payment = new CanRequest();
                $payment->payment_id = $arr['id'];
                $payment->user_id = auth()->user()->id;
                $payment->cans = $quantity;
                $payment->amount = $arr['transactions'][0]['amount']['total'];
                $payment->currency = env('PAYPAL_CURRENCY');
                $payment->payment_status = 'paid';
                $payment->source = 'paypal';

                $payment->save();

                return redirect('/store')->with('success', 'Cans purchased successfully!');

            }
            else{
                return redirect('/store')->with('error', 'Couldn`t make payment !');
            }
        }
        else{
            return redirect('/store')->with('error', 'payment declined!');
        }
    }

    public function errors()
    {
        // return 'User declined the payment!';   
        return redirect('/store')->with('error','User declined the payment!');
    }



    

    public function order_payment(Request $request)
    {
        $request->validate([
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'email' => 'required|email',
            // 'phone_number' => 'nullable|string',
            'address' => 'required|string',
            'city'=> 'required|string',
            'postcode' => 'required|string',
            'quantity.*' => 'required|integer|min:1'
        ]);
        
        $total_price = 0;
        foreach ($request->quantity as $key => $value) {
            $total_price += $value * $request->price[$key];
        }
        try {
            $response = $this->gateway->purchase(array(
                'amount' => $total_price,
                'currency' => env('PAYPAL_CURRENCY'),
                'returnUrl' => route('success-order-payment',['data'=>$request->all()]),
                'cancelUrl' => url('/error-order-payment')
            ))->send();
            if ($response->isRedirect()) {
                $response->redirect();
            }
            else{
                // return $response->getMessage();
                // return redirect('/store')->with('error', $response->getMessage());
                return redirect('/cart')->with('error', $response->getMessage());
            }

        } catch (\Throwable $th) {
            // return $th->getMessage();
            // return redirect('/store')->with('error', $th->getMessage());
            return redirect('/cart')->with('error', $th->getMessage());
        }
    }

    public function order_success(Request $request)
    {
        $data = $request->query('data');
        if ($request->input('paymentId') && $request->input('PayerID')) {
            $transaction = $this->gateway->completePurchase(array(
                'payer_id' => $request->input('PayerID'),
                'transactionReference' => $request->input('paymentId')
            ));

            $response = $transaction->send();

            if ($response->isSuccessful()) {

                $arr = $response->getData();


                $order_datails = OrderDetail::create([
                    'first_name' => $data['first_name'],
                    'last_name' => $data['last_name'],
                    'email' => $data['email'],
                    'phone_number' => $data['phone_number'],
                    'address' => $data['address'],
                    'city' => $data['city'],
                    'amount' => $arr['transactions'][0]['amount']['total'],
                    'payment_id' => $arr['id'],
                    'customer_id' => rand(0,9999999),
                    'payment_status' => "paid",
                    'postcode' => $data['postcode'],
                    'source' => 'paypal',
                ]);
                $order_datails_id = $order_datails->id;
                foreach ($data['ids'] as $key => $value) {
                    Order::create([
                        'order_detail_id' => $order_datails_id,
                        'ad_id' => $value,
                        'quantity' => $data['quantity'][$key]
                    ]);
                }
                
                // $this->OrderConfirmationMail($data);
                return redirect('/cart')->with(['success' => 'Your Order Has Been Placed successfully!', 'status' => 'success']);
                // return redirect('/store')->with('success', 'Cans purchased successfully!');

            }
            else{
                return redirect('/cart')->with('error', 'Couldn`t make payment !');
            }
        }
        else{
            return redirect('/cart')->with('error', 'payment declined!');
        }
    }

    public function order_errors()
    {
        // return 'User declined the payment!';   
        return redirect('/cart')->with('error','User declined the payment!');
    }
    
    function payment_error(){
        return 'No Any Active Payment Method Found !';
    }

}