<?php

namespace App\Http\Controllers;

use App\Models\Accounts;
use App\Models\Payment;
use App\Models\PaymentRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Stripe\Stripe;

class PayoutController extends Controller
{
    public function payout_request(Request $request){
        $request->validate([
            'amount' => 'required|numeric|min:50',
        ]);
        $result = PaymentRequest::create([
            'amount' => $request->amount,
            'user_id' => Auth::id()
        ]);
        if($result){
            return redirect()->back()->with('success', 'Payout request sent successfully. Please wait for admin approval.');
        }
        return redirect()->back()->with('error', 'Something went wrong');
    }

    public function get_payout_requests(Request $request){

        $requests = PaymentRequest::with('user')->whereHas('user',function($query)  use ($request) {
            if ($request->has('search') && $request->search != '') {
                $query->where('name', 'like', '%' . $request->search . '%');
            }
        });
        $requests = $requests
        ->where('status', 'pending')
        ->orderBy('id', 'desc')
        ->paginate(100);
        return view('admin.payout_requests', ['requests' => $requests]);
    }

    public function get_released_payout(Request $request){
        $requests = PaymentRequest::with('user')->whereHas('user',function($query)  use ($request) {
            if ($request->has('search') && $request->search != '') {
                $query->where('name', 'like', '%' . $request->search . '%');
            }
        });
        $requests = $requests
        ->where('status', 'released')
        ->orderBy('id', 'desc')
        ->paginate(100);
        return view('admin.released-payout', ['requests' => $requests]);
    }

    public function payment_getways(){
        $payments = Payment::all();
        return view('admin.payment-getway',compact('payments'));
    }


    public function get_rejected_payout_requests(Request $request){
        $requests = PaymentRequest::with('user')->whereHas('user',function($query)  use ($request) {
            if ($request->has('search') && $request->search != '') {
                $query->where('name', 'like', '%' . $request->search . '%');
            }
        });
        $requests = $requests
        ->where('status', 'rejected')
        ->orderBy('id', 'desc')
        ->paginate(100);
        return view('admin.rejected-payout', ['requests' => $requests]);
    }    

    public function payout_status_update(Request $request, $id){
        $request->validate([
            'status' => 'required',
        ]);

        if($request->status == 'released'){
            $payout = PaymentRequest::where('id', $id)->first();
            $seller_account_id = Accounts::where('user_id',$payout->user_id)->first();
            try {
                Stripe::setApiKey(env('STRIPE_SECRET'));
                $transfer = \Stripe\Transfer::create([
                    'amount' => $payout->amount * 100, // Amount in cents
                    'currency' => 'usd',
                    'destination' => $seller_account_id->account_number,
                    'description' => 'Admin approved payment release to seller',
                ]);

                // Optionally update database
                PaymentRequest::where('id', $id)->update(['status' => $request->status]);
              
                return redirect()->back()->with('success', 'Payment released successfully.');
            } catch (\Exception $e) {
                // return response()->json(['error' => $e->getMessage()], 500);
                return redirect()->back()->with('error', $e->getMessage());
            }
        }
        $result = PaymentRequest::where('id', $id)->update(['status' => $request->status]);
        if($result){
            return redirect()->back()->with('success', 'Payout status updated successfully.');
        }
        return redirect()->back()->with('error', 'Something went wrong');
    }

     // public function payout_status_update(Request $request, $id){
    //     $request->validate([
    //         'status' => 'required',
    //     ]);
    
    //     $payout = PaymentRequest::where('id', $id)->first();
    
    //     // Check if seller has a Stripe account
    //     $sellerAccount = Accounts::where('user_id', $payout->user_id)->first();
    
    //     if (!$sellerAccount) {
    //         try {
    //             $stripe = new \Stripe\StripeClient(env('STRIPE_SECRET'));
    //             $newAccount = $stripe->accounts->create([
    //                 'type' => 'express',
    //                 'country' => 'US',
    //                 'email' => $payout->user->email,
    //             ]);
    
    //             // Save the new account in database
    //             $sellerAccount = Accounts::create([
    //                 'user_id' => $payout->user_id,
    //                 'account_number' => $newAccount->id
    //             ]);
    
    //             \Log::info('New seller account created: ' . json_encode($sellerAccount));
    //         } catch (\Exception $e) {
    //             return redirect()->back()->with('error', 'Stripe Account Creation Failed: ' . $e->getMessage());
    //         }
    //     }
    
    //     if ($request->status == 'released') {
    //         try {
    //             \Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
    //             $transfer = \Stripe\Transfer::create([
    //                 'amount' => $payout->amount * 100, // Amount in cents
    //                 'currency' => 'usd',
    //                 'destination' => $sellerAccount->account_number,
    //                 'description' => 'Admin approved payment release to seller',
    //             ]);
    
    //             // Update payout status
    //             PaymentRequest::where('id', $id)->update(['status' => $request->status]);
    
    //             return redirect()->back()->with('success', 'Payment released successfully.');
    //         } catch (\Exception $e) {
    //             return redirect()->back()->with('error', $e->getMessage());
    //         }
    //     }
    
    //     $result = PaymentRequest::where('id', $id)->update(['status' => $request->status]);
    //     if($result){
    //         return redirect()->back()->with('success', 'Payout status updated successfully.');
    //     }
    //     return redirect()->back()->with('error', 'Something went wrong');
    // }

}
