<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Stripe\Stripe;
use Stripe\Checkout\Session;
use App\Models\Membership;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class MembershipPaymentController extends Controller {
    public function createPayment(Request $request, $membership_id) {
        $membership = Membership::findOrFail($membership_id);

        Stripe::setApiKey(env('STRIPE_SECRET'));

        try {
            $session = Session::create([
                'payment_method_types' => ['card'],
                'line_items' => [[
                    'price_data' => [
                        'currency' => env('STRIPE_CURRENCY', 'USD'),
                        'product_data' => [
                            'name' => $membership->name,
                        ],
                        'unit_amount' => $membership->price * 100, 
                    ],
                    'quantity' => 1,
                ]],
                'mode' => 'payment',
'success_url' => route('membership.success', [
    'membership_id' => $membership->id
]) . '&sesion_id={CHECKOUT_SESSION_ID}',

                'cancel_url' => route('membership.cancel'),
            ]);

            return redirect()->away($session->url);
        } catch (\Exception $e) {
            Log::error('Stripe Payment Error:', ['message' => $e->getMessage()]);
            return view('payments.error', ['message' => 'Something went wrong.']);
        }
    }

public function success(Request $request) {
    \Log::info('Payment Success Route Accessed', $request->all());

    Stripe::setApiKey(env('STRIPE_SECRET'));

    $session_id = $request->query('sesion_id');
    if (!$session_id) {
        return view('payments.error', ['message' => 'Invalid session.']);
    }

    try {
        \Log::info('Session Data:', session()->all());

        $seller = Auth::user()->profile;
        $membership_id = $request->query('membership_id');
        $membership = Membership::findOrFail($membership_id);

        $seller->update([
            'membership_id' => $membership->id,
            'membership_expiry' => now()->addDays($membership->duration_days),
        ]);

        return view('payments.success', ['membership' => $membership]);
    } catch (\Exception $e) {
        Log::error('Stripe Payment Success Error:', ['message' => $e->getMessage()]);
        return view('payments.error', ['message' => 'Payment verification failed.']);
    }
}


    public function cancel() {
        Log::warning('Stripe Payment Cancelled');
        return view('payments.cancel');
    }
}
