<?php

namespace App\Http\Controllers;

use App\Models\Sellerad;
use Illuminate\Http\Request;

class LovecanController extends Controller
{
    public function seller_offers(Request $request){
        $query = Sellerad::query();
        if ($request->has('search') && $request->search != '') {
            $query->where('title', 'like', '%' . $request->search . '%');
        }
        $products = $query->orderBy('id','desc')->paginate(20)->withQueryString();
        return view('admin.seller-offers',['data'=>$products]);
    }

    public function seller_ad_view($id){
        $sellerad = Sellerad::with('user')
        ->where('id', $id)->first();
        return view('admin.seller-ad-details',compact('sellerad'));
    }

    public function receive_seller_ad($id){
        Sellerad::where('id', $id)->update(['is_received' => 1]);
        return redirect()->back();
    }
    public function pay_seller_ad($id){
        Sellerad::where('id', $id)->update(['payment_status' => 1]);
        return redirect()->back();
    }

    public function udpate_offer_status(Request $request, $id){
        Sellerad::where('id', $id)->update(['offer_status' => $request->offer_status]);
        return redirect()->back();
    }
}
