<?php
namespace App\Http\Controllers;

use App\Models\Cart;
use App\Models\Order;
use App\Models\Payment;
use Illuminate\Http\Request;
use Stripe\Checkout\Session as StripeSession;
use Stripe\Stripe;

class CheckoutController extends Controller
{
    public function checkout(Request $request)
    {
        Stripe::setApiKey('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');

        // Retrieve cart items
        $cartItems = Cart::with('product')->where('user_id', auth()->id())->get();

        foreach ($cartItems as $item) {
            Order::create([
                'user_id' => auth()->id(),
                'product_id' => $item->product_id,
                'quantity' => $item->quantity,
                'address' => $request->address,
                'city' => $request->city,
                'state' => $request->state,
                'country' => $request->country,
                'zipcode' => $request->zipcode,
                'phone' => $request->phone,
            ]);
        }

        // Calculate total amount
        $totalAmount = $cartItems->sum(function ($cart) {
            return $cart->product->price * $cart->quantity;
        });
        // Prepare line items for Stripe
        $lineItems = $cartItems->map(function ($cart) {
            return [
                'price_data' => [
                    'currency' => 'usd',
                    'product_data' => [
                        'name' => $cart->product->name,
                    ],
                    'unit_amount' => (int) round($cart->product->price * 100), // Convert to cents
                ],
                'quantity' => (int) $cart->quantity,
            ];
        })->toArray();

        // Create Stripe session
        $session = StripeSession::create([
            'payment_method_types' => ['card'],
            'line_items' => $lineItems,
            'mode' => 'payment',
            'success_url' => route('checkout.success') . '?session_id={CHECKOUT_SESSION_ID}',
            'cancel_url' => route('cart.index'),
        ]);

        return redirect($session->url);
    }


    public function success(Request $request)
    {
        // dd($request->all());
        $order = Order::where('user_id', auth()->id())->latest()->first();
        $order->update(['status' => 'completed']);

        $cartItems = Cart::where('user_id', auth()->id())->get();
        $totalAmount = $cartItems->sum(function ($cart) {
            return $cart->product->price * $cart->quantity;
        });

        Payment::create([
            'user_id' => auth()->id(),
            'amount' => $totalAmount,
            'status' => 'success',
            'stripe_payment_id' => $request->session_id,
        ]);

        Cart::where('user_id', auth()->id())->delete();

        return redirect()->route('cart.index')->with('success', 'Payment successful!');
    }
}

