<?php

namespace App\Http\Controllers;

use App\Models\Can;
use App\Models\CanRequest;
use Illuminate\Http\Request;

class CanController extends Controller
{
    public function buyCans(Request $request){
        $validated = $request->validate([
            'quantity' => 'required|integer|min:1',
        ]);

        $user = auth()->user(); // Assuming the seller is authenticated

        // Add cans to seller's stock
        $can = $user->cans()->firstOrCreate();
        $can->stock += $validated['quantity'];
        $can->save();

        return redirect()->route('seller.dashboard')->with('success', 'Cans purchased successfully!');
    }

    public function purchase_cans(Request $request){
        $validated = $request->validate([
            'quantity' => 'required|integer|min:1',
        ]);

        $user = auth()->user(); // Assuming the seller is authenticated

        // Add cans to seller's stock
        $can = $user->cans()->firstOrCreate();
        $can->stock += $validated['quantity'];
        $can->save();    

        return redirect()->route('seller.dashboard')->with('success', 'Cans purchased successfully!');
    }

    public function checkout(Request $request){
        $price = $request->quantity*20;
        // dd($request);
        return view('seller.store.checkout',['price'=>$price,'quantity'=>$request->quantity]);
    }

    public function status_update(Request $request, $id){
        CanRequest::where('id',$id)->update([
            'status' => $request->status
        ]);


        if($request->status == 'Approved'){
            $cans = CanRequest::where('id',$id)->first();
            $can = Can::firstOrNew(
                ['user_id' => $cans->user_id],
                [
                    'stock' => 0
                ]          
            );
            $can->stock += $cans->cans;
            $can->save(); 
        }
        return redirect()->back();
    }

}
