<?php

namespace App\Http\Controllers;

use App\Models\BannerSlider;
use Illuminate\Http\Request;

class BannerSliderController extends Controller
{
    public function index(){
        $bannersliders = BannerSlider::orderBy('created_at', 'desc')->paginate(10);
        return view('admin.bannerslider.index', compact('bannersliders'));
    }

    public function create(){
        return view('admin.bannerslider.create');
    }

    public function store(Request $request){
        $request->validate([
            'sliderimages' => 'required|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048'
        ]);

        if ($request->hasFile('sliderimages')) {
            $path = $request->file('sliderimages')->store('bannerimages', 'public');
        }

        BannerSlider::create([
            'sliderimages' => $path
        ]);

        return redirect()->route('slider.index')->with('success', 'Image uploaded successfully.');
    }



    public function edit($id){
        $bannerslider = BannerSlider::find($id);
        return view('admin.bannerslider.edit', compact('bannerslider'));
    }

    public function update(Request $request, $id)
{
    $bannerslider = BannerSlider::find($id);
    if (!$bannerslider) {
        return redirect()->route('slider.index')->with('error', 'Banner not found.');
    }
    $request->validate([
        'sliderimages' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048'
    ]);
    if ($request->hasFile('sliderimages')) {
        if ($bannerslider->sliderimages && file_exists(storage_path('app/public/' . $bannerslider->sliderimages))) {
            unlink(storage_path('app/public/' . $bannerslider->sliderimages));
        }
        $path = $request->file('sliderimages')->store('bannerimages', 'public');
        $bannerslider->sliderimages = $path;
    }
    $bannerslider->save();
    return redirect()->route('slider.index')->with('success', 'Banner updated successfully.');
}


    public function destroy($id){
        $bannerslider = BannerSlider::find($id);
        $bannerslider->delete();
        return redirect()->route('slider.index')->with('success', 'Banner Delete successfully.');
    }
}
