<?php

namespace App\Http\Controllers;

use App\Models\Accounts;
use Illuminate\Http\Request;
use Stripe\Stripe;
use Stripe\Account;
use Illuminate\Support\Facades\Auth;
use Stripe\StripeClient;


class AccountController extends Controller
{
    public function add_account($id) { 
        $accountId = $id; // Pass the account_id as a query parameter
        
        $profile = Auth::user()->profile;
        Stripe::setApiKey(env('STRIPE_SECRET'));
        $account = Account::retrieve($accountId);
        if ($account->requirements->disabled_reason === null) {
            Accounts::create([
                'account_name' => auth()->user()->name,
                'method' => 'stripe',
                'account_number' => $accountId,
                'user_id' => auth()->user()->id
            ]);
            return redirect()->route('profile.balance')->with(['profile' => $profile,'success'=> 'Account is created successfully.']);
        } else {
            // return view('profile_components.balance', ['profile' => $profile])->with('error', 'Account is not created successfully.');
            return redirect()->route('profile.balance')->with(['profile' => $profile,'error'=>  'Account is not created successfully.']);
        } 
    }


    public function add_seller_account(Request $request)
{
    try {
        // Create Stripe client
        $stripe = new StripeClient(env('STRIPE_SECRET'));

        $user = Auth::user();

        // Create a new Express Connect account
        $account = $stripe->accounts->create([
            'type' => 'express',
            'country' => 'US',
            'email' => $user->email,
            'capabilities' => [
                'card_payments' => ['requested' => true],
                'transfers' => ['requested' => true],
            ],
        ]);

        // Save to your local database
        Accounts::updateOrCreate(
            ['user_id' => $user->id],
            [
                'account_number' => $account->id,
                'account_name' => $user->name,
                'method' => 'stripe',
            ]
        );

        return response()->json([
            'message' => 'Stripe account created successfully.',
            'account' => $account,
        ]);

    } catch (\Exception $e) {
        return response()->json(['error' => $e->getMessage()], 500);
    }
}

    

    public function delete_account() {
        $account = Accounts::where('user_id', Auth::id())->first();
        if ($account->delete()) {
            return redirect()->back()->with(['success'=> 'Account is deleted successfully.']);
        }
        return redirect()->back()->with(['error'=> 'Account is could not be deleted successfully.']);
    }


}
