<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use App\Mail\AdminNotificationMail;
use App\Mail\SellerNotificationMail;

class CheckUserInactivity extends Command
{
    // Command signature
    protected $signature = 'users:check-inactivity';

    // Command description
    protected $description = 'Check for inactive users and notify or delete accounts based on inactivity.';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        // Get users inactive for 10 months
        $inactiveFor10Months = User::where('last_active_at', '<=', now()->subMonths(10))
                                   ->where('last_active_at', '>', now()->subMonths(12))
                                   ->get();

        foreach ($inactiveFor10Months as $user) {
            // Notify Admin and Seller
            Mail::to('admin@example.com')->send(new AdminNotificationMail($user));
            Mail::to($user->email)->send(new SellerNotificationMail($user, 'notification'));
        }

        // Get users inactive for 12 months
        $inactiveFor12Months = User::where('last_active_at', '<=', now()->subMonths(12))->get();

        foreach ($inactiveFor12Months as $user) {
            // Send deletion notification
            Mail::to('admin@example.com')->send(new AdminNotificationMail($user, true));
            Mail::to($user->email)->send(new SellerNotificationMail($user, 'deletion'));

            // Delete user account
            // $user->delete();
        }

        $this->info('Inactivity check completed.');
    }
}

?>