<?php

namespace App\Console\Commands;

use App\Services\DynamicArchiveService;
use Illuminate\Console\Command;

class ArchiveAllTables extends Command
{
    protected $signature = 'tables:archive';
    protected $description = 'Archive old records from all tables dynamically';

    protected $archiveService;

    public function __construct(DynamicArchiveService $archiveService)
    {
        parent::__construct();
        $this->archiveService = $archiveService;
    }

    public function handle()
    {
        $this->info("Archiving old records from all tables...");
        $this->archiveService->archiveOldRecords();
        $this->info("Archiving completed successfully!");
    }
}

