<?php include 'head.html';
include 'includes/functions.php';

$id = isset($_GET['id']) ? htmlspecialchars($_GET['id']) : null;

if (!$id) {
    header("HTTP/1.0 404 Not Found");
    header("Location: /404.php"); // Change this to your actual 404 page
    exit();
}

$data = getArchiveIssues($id);
$url = getSiteURl();

//echo "<pre>";
//print_r($data);
//echo "</pre>";




?>




<body>

	<!-- Preloader -->
	<div class="loader-mask">
		<div class="loader">
			"Loading..."
		</div>
	</div>

	<main class="main-wrapper">
<?php include 'headerpage.html'; ?>
		

		<div class="content-wrapper content-wrapper--boxed oh">

      <!-- Page Title -->
      <section class="page-title bg-dark-overlay text-center" style="background-image: url(img/page-title-banner.jpg);">
        <div class="container">
          <div class="page-title__holder">
            <h1 class="page-title__title"><?php echo $data['identification']?></h1>
					
          </div>
        </div>
      </section> <!-- end page title -->
      
      
      <!-- Team -->
			<section class="section-wrap" >
				<div class="container">
					<div class="row">
					    
					    <div class="col-lg-9">
					    
					    <?php
					    
					    
					      if (isset($data['articles']) && is_array($data['articles'])) {
                                foreach ($data['articles'] as $article) {
                                    ?>
                                    <div class="curated-cards__body">
                                        <div class="curated-cards__heading-wrap">
                                            <h2 class="curated-cards__heading">
                                                <a href="<?= $url . '/article-view.php?subid=' . urlencode($article['id']) . '&pubid=' . urlencode($article['publication']['id']) ?>" class="js-card-link curated-cards__heading-link" target="_blank" rel="noopener noreferrer">
                                                    <?= htmlspecialchars($article['publication']['fullTitle'] ?? '') ?>
                                                </a>
                                            </h2>
                                        </div>
                                        <div class="curated-cards__text">
                                            <?= htmlspecialchars($article['publication']['authorsStringShort'] ?? '') ?>
                                        </div>
                                        <div class="curated-cards__text" style="margin-top: 16px;">
 <a href="<?= $url . '/article-view.php?subid=' . urlencode($article['id']) . '&pubid=' . urlencode($article['publication']['id']) ?>">
    read more
</a>



                                        </div>
                                    </div>
                                    <?php
                                }
                            } else {
                                echo "<p>No articles found.</p>";
                            }
					    
					    
					    
					    
					    ?>
					    
					    
					    
					    </div>
					    
					    
					    
						<div class="col-lg-3">
						    
						    <a href="#" class="btn btn--md btn--dark">
											<span>Make Submission</span>
							</a>
						    
						    <div style="margin: 20px 0">
						        <a href="https://www.scimagojr.com/journalsearch.php?q=17700156017&amp;tip=sid&amp;exact=no" title="SCImago Journal &amp; Country Rank" bis_skin_checked="1" bis_size="{&quot;x&quot;:1084,&quot;y&quot;:961,&quot;w&quot;:200,&quot;h&quot;:19,&quot;abs_x&quot;:1084,&quot;abs_y&quot;:961}"><img decoding="async" border="0" src="https://www.scimagojr.com/journal_img.php?id=17700156017" alt="SCImago Journal &amp; Country Rank" bis_size="{&quot;x&quot;:1084,&quot;y&quot;:959,&quot;w&quot;:200,&quot;h&quot;:200,&quot;abs_x&quot;:1084,&quot;abs_y&quot;:959}" bis_id="bn_g6tmshkhfxgmdur26x8hds"></a>				
						   </div>
						   
						   
						    <div style="margin: 20px 0">
						        <h4>Information</h4>
						        <ul>
						            <li><a href="#">For Readers</a>
						            </li>
						            <li><a href="#">For Authors</a>
						            </li>
						            <li><a href="#">For Librarians</a>
						            </li>
						        </ul>
						        </div>
						   
						   
						</div><!--sidebar end-->

					

					</div>
				</div>
			</section> <!-- end team -->
			
      
      



		

		</div> <!-- end content wrapper -->

<?php include 'footer.html'; ?>
		
		
