<?php


function getSiteURl(){

    $config = include 'config.php';

    return  $config['site_url'];
}

function fetchCurrentIssues()
{
    $config = include 'config.php';

    $apiUrl = $config['base_url'] . "/issues/current";
    $apiKey = $config['api_key'];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiKey,
        'Accept: application/json'
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        return ['error' => curl_error($ch)];
    }

    curl_close($ch);

$data = json_decode($response, true);

// Extract required fields
$result = [
    'articles' => array_values(array_filter(array_map(function ($article) {
        $publication = $article['publications'][0] ?? []; // Get the first object instead of an array

        return [
            'currentPublicationId' => $article['currentPublicationId'] ?? null,
            'id' => $article['id'] ?? null,
            'dateSubmitted' => $article['dateSubmitted'] ?? null,
            'statusLabel' => $article['statusLabel'] ?? null,
            'publication' => [
                'authorsStringShort' => $publication['authorsStringShort'] ?? null,
                'fullTitle' => $publication['fullTitle']['en_US'] ?? null,
                'id' => $publication['id'] ?? null
            ]
        ];
    }, $data['articles'] ?? []), function ($article) {
        return $article['statusLabel'] === "Published";
    })),
    'datePublished' => $data['datePublished'] ?? null,
    'id' => $data['id'] ?? null,
    'identification' => $data['identification'] ?? null,
    'lastModified' => $data['lastModified'] ?? null,
    'volume' => $data['volume'] ?? null,
    'year' => $data['year'] ?? null
];

// Sort articles by dateSubmitted in ascending order
usort($result['articles'], function ($a, $b) {
    return strtotime($a['dateSubmitted']) <=> strtotime($b['dateSubmitted']);
});

// Return JSON response
return $result;
}

function fetchSubmissions($submissionId)
{
    $config = include 'config.php';

    $submissionUrl = $config['base_url'] . "/submissions/{$submissionId}/publications";
    $apiKey = $config['api_key'];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $submissionUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiKey,
        'Accept: application/json'
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        return ['error' => curl_error($ch)];
    }

    curl_close($ch);

    return json_decode($response, true);
}

function fetchCurrentIssuesWithExtraFields()
{
    $mainObject = fetchCurrentIssues();

    $newSubmissions = [];

    if (isset($mainObject['articles']) && is_array($mainObject['articles'])) {
        foreach ($mainObject['articles'] as $article) {
            if (isset($article['id'])) {
                $submissionData = fetchSubmissions($article['id']);
                if ($submissionData) {
                    $newSubmissions[] = $submissionData; // Collect only submissions
                }
            }
        }
    }

    // Replace `articles` with `submissions`
    $mainObject['submissions'] = $newSubmissions;
    unset($mainObject['articles']); // Remove `articles` key

    return $mainObject;
}

function fetchPublication($submissionId,$publicationId)
{
    $config = include 'config.php';

//    $apiUrl = $config['base_url'] . "/issues/current";
    $apiUrl = $config['base_url'] . "/submissions/{$submissionId}/publications/{$publicationId}";
    $apiKey = $config['api_key'];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiKey,
        'Accept: application/json'
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        return ['error' => curl_error($ch)];
    }

    curl_close($ch);

$data = json_decode($response, true);

// Extract required fields
$result = [
    'fullTitle'=>$data['fullTitle']['en_US'] ?? '',
    'abstract' => $data['abstract']['en_US'] ?? '',
    'authors' => array_map(function ($author) {
        return [
            'givenName' => $author['givenName']['en_US'] ?? '',
            'affiliation' => $author['affiliation']['en_US'] ?? ''
        ];
    }, $data['authors'] ?? []),
    'keywords' => $data['keywords']['en_US'] ?? [],
    'doi' => $data['pub-id::doi'] ?? '',
    'datePublished' => $data['datePublished'] ?? '',
     'pdf' => ''
];

if (!empty($data['galleys'])) {
    foreach ($data['galleys'] as $galley) {
        if ($galley['file']['documentType'] === 'pdf') {
            $result['pdf'] = $galley['urlPublished'] ?? '';
            break; // Stop after finding the first PDF
        }
    }
}

return $result;
}


function getArchive(){

    $config = include 'config.php';

//    $apiUrl = $config['base_url'] . "/issues/current";
    $apiUrl = $config['base_url'] . "/issues?count=100&orderBy=years&isPublished=true";
    $apiKey = $config['api_key'];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiKey,
        'Accept: application/json'
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        return ['error' => curl_error($ch)];
    }

    curl_close($ch);

$data = json_decode($response, true);

// Extract the required fields
$filteredItems = array_map(function ($item) {
    return [
        "datePublished" => $item["datePublished"],
        "id" => $item["id"],
        "identification" => $item["identification"],
        "number" => $item["number"],
        "volume" => $item["volume"],
        "year" => $item["year"]
    ];
}, $data["items"]);

return $filteredItems;


}

function getArchiveIssues($issueID){

    $config = include 'config.php';

//    $apiUrl = $config['base_url'] . "/issues/current";
    $apiUrl = $config['base_url'] . "/issues/{$issueID}";

    $apiKey = $config['api_key'];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiKey,
        'Accept: application/json'
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        return ['error' => curl_error($ch)];
    }

    curl_close($ch);
    
$data = json_decode($response, true);

// Extract required fields
$result = [
    'articles' => array_values(array_filter(array_map(function ($article) {
        $publication = $article['publications'][0] ?? []; // Get the first object instead of an array

        return [
            'currentPublicationId' => $article['currentPublicationId'] ?? null,
            'id' => $article['id'] ?? null,
            'dateSubmitted' => $article['dateSubmitted'] ?? null,
            'statusLabel' => $article['statusLabel'] ?? null,
            'publication' => [
                'authorsStringShort' => $publication['authorsStringShort'] ?? null,
                'fullTitle' => $publication['fullTitle']['en_US'] ?? null,
                'id' => $publication['id'] ?? null
            ]
        ];
    }, $data['articles'] ?? []), function ($article) {
        return $article['statusLabel'] === "Published";
    })),
    'datePublished' => $data['datePublished'] ?? null,
    'id' => $data['id'] ?? null,
    'identification' => $data['identification'] ?? null,
    'lastModified' => $data['lastModified'] ?? null,
    'volume' => $data['volume'] ?? null,
    'year' => $data['year'] ?? null
];

// Sort articles by dateSubmitted in ascending order
usort($result['articles'], function ($a, $b) {
    return strtotime($a['dateSubmitted']) <=> strtotime($b['dateSubmitted']);
});

return $result;



}




