<?php include 'head.html'; ?>




<body>

	<!-- Preloader -->
	<div class="loader-mask">
		<div class="loader">
			"Loading..."
		</div>
	</div>

	<main class="main-wrapper">
<?php include 'headerpage.html'; ?>
		

		<div class="content-wrapper content-wrapper--boxed oh">

      <!-- Page Title -->
      <section class="page-title bg-dark-overlay text-center" style="background-image: url(img/page-title-banner.jpg);">
        <div class="container">
          <div class="page-title__holder">
            <h1 class="page-title__title">Information for Authors</h1>
					
          </div>
        </div>
      </section> <!-- end page title -->
      
      
      <!-- Team -->
			<section class="section-wrap" >
				<div class="container">
					<div class="row">
					    
					    <div class="col-lg-9">
					        
					     
					     <div class="intro" style="text-align: justify;margin-bottom: 35px;">
					         
								
								<p>The journal accepts the following types of articles for publication:</p>
								      <ol>
                                        <li>Research articles:&nbsp;<strong>9000</strong>&nbsp;words,&nbsp;<em>including</em>&nbsp;abstract, footnotes, and references</li>
                                        <li>Discussion&amp;Replies:&nbsp;<strong>4000</strong>&nbsp;words</li>
                                        <li>Book Reviews:&nbsp;<strong>2000</strong>&nbsp;words (see&nbsp;<a href="https://philosophy-of-religion.eu/ext_docs/EJPR_Stylesheet.pdf" target="_blank" rel="noopener">Book Review Guidelines</a>)</li>
                                        </ol>  
                                        
                            <p><b>Manuscripts exceeding these limits will not be considered!</b></p>   
                            <p>When you first submit your paper, you only need an anonymized PDF ready for review. Once your paper has been accepted, you have to provide:</p>
                            <ul>
                                <li>a manuscript using <a href="https://philosophy-of-religion.eu/ext_docs/templates/EJPRTemplate.dotx" target="_blank" rel="noopener">this template</a>&nbsp;and&nbsp;</li>
                                <li>a *.ris-file with all reference data.&nbsp;</li>
                            </ul>
                            <p>Please also check <strong>general information for authoring</strong> in OJS <strong><a href="https://docs.pkp.sfu.ca/learning-ojs/3.2/en/authoring" target="_blank" rel="noopener">here</a> </strong>and the <strong>EJPR Stylesheet</strong>.</p>
                            <p>Following some advice for preparing the manuscript. </p>
					    </div>
							
						<div class="contact" style="margin-bottom: 40px; text-align: justify;">
                			<h5 class="mb-32">Manuscript Preparation</h5>
                			 <p>The manuscript is</p>
                			 <ul>
                                <li>1,5-spaced&nbsp;</li>
                                <li>set in 12-point font</li>
                                <li><strong>section headings</strong>&nbsp;are bold and centred&nbsp;(or otherwise recognizable as such)</li>
                                <li><em>subsection headings</em>&nbsp;are in italics and centred (or otherwise recognizable as such)</li>
                                <li>long quotes are indented and easily recognizable as such in the layout process.</li>
                                <li>all illustrations, figures, and tables are placed within the text at the appropriate points, rather than at the end.</li>
                            </ul>
                            <p>We have a Word template for this <strong>here</strong> (take this for Word 97-2003 or Open-/LibreOffice). If you (understandably) prefer LaTeX, this line in <a href="https://www.pandoc.org/">pandoc</a> will do the trick in most cases &lt;pandoc “filename.tex” -f latex -t docx -o “filename.docx”&gt; providing a Word file as requested by the EJPR-Team.&nbsp;</p>   
                			 
					</div>	
							
						 <div class="intro" style="text-align: justify;margin-bottom: 35px;">
								<h5 class="mb-32">Reference Management Software</h4>
								<p>Providing a<strong> *.ris-file</strong> containing the cited references is <strong>mandatory</strong>. You can build such a file with any reference management software (here is an <a href="https://en.wikipedia.org/wiki/Comparison_of_reference_management_software" target="_blank" rel="noopener">overview</a>). If you plan to use a citation software while preparing the manuscript, we recommend using Citavi or Zotero as software. Both offer our journal citation style as predefined citation option.&nbsp;</p>
								<p>Our team mainly works with&nbsp;<a href="https://www.citavi.com/" target="_blank" rel="noopener">Citavi</a>, an excellent piece of software with many useful features for citation and knowledge&nbsp;management. Unfortunately, Citavi is not free and runs only on Windows,&nbsp;so it might not be the best choice for everyone.&nbsp;</p>
								<p>A good alternative option is&nbsp;&nbsp;<a href="https://zotero.org" target="_blank" rel="noopener">Zotero</a>. It is free, open-source and runs on Windows, Mac and Linux. You can find help and support <a href="https://www.zotero.org/support/" target="_blank" rel="noopener">here</a>&nbsp;and <a href="https://forums.zotero.org/discussions" target="_blank" rel="noopener">here</a>.</p>
								<p>Anyway, you can use any software you like, as long as it able to import <a href="https://citationstyles.org/">CSL</a> citation styles (i.e. any recent citation software). You can download <a href="https://www.zotero.org/styles?q=id%3Aeuropean-journal-for-philosophy-of-religion" target="_blank" rel="noopener">here</a>&nbsp;our style definition.</p>
								<p>If you have not being using a citation management software before, you might consider downloading this bibliography file: <a href="https://webftp.your-server.de/index.php?r=/download&amp;path=L3B1YmxpY19odG1sL0VKUFIvZXh0X2RvY3MvRUpQUi1CaWIucmlz">EJPR.ris</a> or <a href="https://webftp.your-server.de/index.php?r=/download&amp;path=L3B1YmxpY19odG1sL0VKUFIvZXh0X2RvY3MvRUpQUi1CaWIuYmli">EJPR.bib</a>. There are 3200+ entries on philosophy to start with.&nbsp;</p>
								
						</div>
						
					    
					    </div>
					    
					    
						<div class="col-lg-3">
						     <?php include 'sidebar.html'; ?>
						   
						</div><!--sidebar end-->

					

					</div>
				</div>
			</section> <!-- end team -->
			
      
      



		

		</div> <!-- end content wrapper -->

<?php include 'footer.html'; ?>
		
		
