<?php include 'head.html';
include 'includes/functions.php';

$subid = isset($_GET['subid']) ? htmlspecialchars($_GET['subid']) : null;
$pubid = isset($_GET['pubid']) ? htmlspecialchars($_GET['pubid']) : null;

if (!$subid || !$pubid) {
    header("HTTP/1.0 404 Not Found");
    header("Location: /404.php"); // Change this to your actual 404 page
    exit();
}

$data = fetchPublication($subid,$pubid);

echo "<pre>";
print_r($data);
echo "</pre>";






?>




<body>

	<!-- Preloader -->
	<div class="loader-mask">
		<div class="loader">
			"Loading..."
		</div>
	</div>

	<main class="main-wrapper">

		<?php include 'headerpage.html'; ?>


		<div class="content-wrapper content-wrapper--boxed oh">

			<!-- Page Title -->
			<section class="page-title bg-dark-overlay text-center" style="background-image: url(img/page-title-banner.jpg);">
				<div class="container">
					
				</div>
			</section> <!-- end page title -->

			<!-- Service -->
			<section class="section-wrap pb-0">
				<div class="box-offset-container">
					<div class="container">
						<div class="row">
							<div class="col-lg-10">
								<div class="entry__article">
									<h3><?php echo $data['fullTitle']?></h3>
									
                        									<?php
                        // Assuming $data['authors'] contains the author details
                        if (!empty($data['authors'])) {
                            foreach ($data['authors'] as $author) {
                                $givenName = htmlspecialchars($author['givenName'] ?? '');
                                $affiliation = htmlspecialchars($author['affiliation'] ?? '');
                        
                                echo "<p><b>{$givenName}</b><br>{$affiliation}</p>";
                            }
                        } else {
                            echo "";
                        }
                        ?>

									
		
									<p><b>DOI:</b> https://doi.org/<?php echo $data['doi'];?></p>
								
								
								
								
								
								<div class="intro" style="text-align: justify;margin-bottom: 35px;">
            					         <h5>Abstract</h5>
            					         <p><?php echo $data['abstract'];?></p>
            					</div>
									
									<p><b>Keywords:</b> <?php echo $data['keywords'][0]; ?> </p>
									
									<p><a href="<?php echo $data['pdf'];?>" target=_blank class="btn btn--lg btn--color">
                                        <span>Download PDF</span>
					                        </a></p>
									
								</div>
							</div>
						</div>
					</div>
				</div>
			</section> <!-- end service -->


</div>			

<?php include 'footer.html';?>